IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Contratos_Producto_Generar') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Contratos_Producto_Generar 
END
GO

CREATE PROCEDURE [dbo].[CPJ_Contratos_Producto_Generar] @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON 
/*Variables recibidas por parmetro a traves del JSON*/
DECLARE @pFlagUsarTrans		TINYINT
DECLARE @pModoDebug			TINYINT
DECLARE @pId_Contrato		INT
DECLARE @pItem				INT
DECLARE @pId_Producto		VARCHAR(14)
DECLARE @pId_Prod_Familia_Sala	VARCHAR(14)
DECLARE @pPrecio			DECIMAL(15,5)
DECLARE @pCant_Cuotas		INT
DECLARE @pFlag_Facturable   INT
DECLARE @pCantidad			INT	

/*				*/
SET @pFlagUsarTrans			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Contrato			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Contrato')), 0)
SET @pItem					= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Item')), 1)
SET @pId_Producto			= ISNULL(CONVERT(VARCHAR(14), dbo.CF_JSON_VALUE(@pJson,'Id_Producto')), 0)
SET @pId_Prod_Familia_Sala	= ISNULL(CONVERT(VARCHAR(14), dbo.CF_JSON_VALUE(@pJson,'Id_Prod_Familia_Sala')), 0)
SET @pPrecio				= ISNULL(CONVERT(DECIMAL(5,2), dbo.CF_JSON_VALUE(@pJson,'Porc_Iva')), 0)
SET @pCant_Cuotas			= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Cant_Cuotas')), 1)
SET @pFlag_Facturable		= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Flag_Facturable')), 1)
SET @pCantidad				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Cantidad')), 1)
/*FIN Variables recibidas por parmetro a traves del JSON*/


/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored			INT
DECLARE @rtaMsjStored			VARCHAR(4000)
/*FIN Variable de Retorono del Stored*/

/*Declaracion Variables Locales*/
/*Fin de Declaraciones Variables Locales */



BEGIN TRY

	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END
	
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Contratos_Producto_Generar'
	END
	
	/*===================================================================*/


	/*===================================================================*/

	
	IF(@pId_Contrato = 0)  RAISERROR ('Id_Contrato can not be zero.', 16,  1 )

		
	/*===================================================================*/
	
	

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Inserto en Contratos Prod.'
	END
	
	IF(@pId_Contrato <> 0)
	BEGIN
		
		INSERT INTO Contratos_Prod(Id_Contrato, Item, Id_Producto, Precio, Cant_Cuotas, Flag_Facturable, Cantidad, Id_Prod_Familia_Sala)
		VALUES (@pId_Contrato, @pItem,@pId_Producto,@pPrecio,@pCant_Cuotas,@pFlag_Facturable,@pCantidad,@pId_Prod_Familia_Sala)
	END


	
	/*===================================================================*/	
	
	SET @rtaMsjStored		=	'{' +
								dbo.CF_Json_ParsearVariable('id_contrato', @pId_Contrato, 'INT')  + ',' +
								'}'
								
	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,@pId_Contrato	AS ErrorLine		
			,@rtaMsjStored	AS ErrorMessage

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Contratos_Producto_Generar'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0 
	BEGIN
		ROLLBACK
	END

	RETURN 9999
END CATCH

RETURN 0

--Ejemplo de uso
--EXEC CPJ_Contratos_Producto_Generar '{"FlagUsarTrans":"0", "ModoDebug":"1", "Id_Contrato":"593401", "Item":"1", "Id_Producto":"1015_03","Precio":"", "Cant_Cuotas":"1", "Cant_Cuotas":"", "Flag_Facturable":"", "Cantidad":"", "Id_Prod_Familia_Sala":""}'

